{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.09.98 - 10:49:57 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMObj, MMUtils, MMDIBCv, MMLevel, MMConect, MMDesign,
  MMWave, MMWaveIO, MMDSPObj, MMWavOut, MMACMCvt, MMHook, MMWavIn;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    Connector: TMMConnector;
    MMLevel1: TMMLevel;
    btnStop: TButton;
    btnRecord: TButton;
    DSPInterface: TMMDSPInterface;
    WaveIn: TMMWaveIn;
    SaveDialog: TSaveDialog;
    procedure btnRecordClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DSPInterfaceOpen(Sender: TObject);
    procedure DSPInterfaceClose(Sender: TObject);
    procedure DSPInterfaceBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
  private
    FFileName: string;
    FHandle  : THandle;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses uLaw;

// if you need any byte conversion remove the point and
// include your conversion in OnBufferReady
{.$DEFINE ULAW_CONVERT}

{------------------------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
begin
   if SaveDialog.Execute then
   begin
      FFileName := SaveDialog.FileName;

      { start recording }
      WaveIn.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveIn.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveIn.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceOpen(Sender: TObject);
begin
   FHandle := FileCreate(FFileName);
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceClose(Sender: TObject);
begin
   FileClose(FHandle);
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
var
   dwLength: Longint;
   lpData: PSmallArray;
{$IFDEF ULAW_CONVERT}
   i: integer;
   Buf: array[0..8192-1] of Char;// depends on the buffersize of WaveIn
{$ENDIF}
begin
   dwLength := lpWaveHdr^.dwBytesRecorded;
   lpData   := Pointer(lpWaveHdr^.lpData);
   {$IFDEF ULAW_CONVERT}
   for i := 0 to (dwLength div 2)-1 do
   begin
      Buf[i] := Char(Linear2uLaw(lpData[i],False));
   end;
   dwLength := dwLength div 2;
   FileWrite(FHandle,Buf,dwLength);
   {$ELSE}
   FileWrite(FHandle,lpData^,dwLength);
   {$ENDIF}
end;

end.
